/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.sound.IGeomancyRumbler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityPillarPiece;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityPillar
extends EntityGeomancyBase
implements IGeomancyRumbler {
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.m_135353_(EntityPillar.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> RISING = SynchedEntityData.m_135353_(EntityPillar.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FALLING = SynchedEntityData.m_135353_(EntityPillar.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final float RISING_SPEED = 0.25f;
    public float prevPrevHeight = 0.0f;
    public float prevHeight = 0.0f;
    public static final HashMap<EntityGeomancyBase.GeomancyTier, Integer> SIZE_MAP = new HashMap();
    private EntityPillarPiece currentPiece;

    public EntityPillar(EntityType<? extends EntityMagicEffect> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityPillar(EntityType<? extends EntityPillar> type, Level world, LivingEntity caster, BlockState blockState, BlockPos pos) {
        super(type, world, caster, blockState, pos);
        this.setDeathTime(300);
    }

    public boolean checkCanSpawn() {
        if (!this.m_9236_().m_45976_(EntityPillar.class, this.m_20191_().m_82406_(0.01)).isEmpty()) {
            return false;
        }
        return this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82406_(0.01));
    }

    public boolean m_7337_(Entity p_20303_) {
        return false;
    }

    @Override
    public boolean m_5829_() {
        return false;
    }

    @Override
    public void m_8119_() {
        this.prevPrevHeight = this.prevHeight;
        this.prevHeight = this.getHeight();
        if (this.f_19803_) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 2.0f, 1.0f);
            if (!this.isFalling()) {
                this.startRising();
            }
            if (this.m_9236_().m_5776_()) {
                MowziesMobs.PROXY.playGeomancyRumbleSound(this);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.isRising()) {
                height = this.getHeight();
                if ((double)height == 0.0) {
                    this.currentPiece = new EntityPillarPiece((EntityType)EntityHandler.PILLAR_PIECE.get(), this.m_9236_(), this, new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()));
                    this.m_9236_().m_7967_((Entity)this.currentPiece);
                }
                this.setHeight(height += 0.25f);
                if (Math.floor(height) > Math.floor(this.prevHeight)) {
                    this.currentPiece = new EntityPillarPiece((EntityType)EntityHandler.PILLAR_PIECE.get(), this.m_9236_(), this, new Vec3(this.m_20185_(), this.m_20186_() + Math.floor(height) - 1.0, this.m_20189_()));
                    this.m_9236_().m_7967_((Entity)this.currentPiece);
                }
                if (!(this.getCaster() instanceof EntitySculptor)) {
                    List boulders = this.m_9236_().m_45976_(EntityBoulderProjectile.class, this.m_20191_().m_82406_((double)0.1f));
                    for (EntityBoulderProjectile boulder : boulders) {
                        if (boulder.isTravelling() || boulder.getTier().ordinal() <= this.getTier().ordinal()) continue;
                        this.setTier(boulder.getTier());
                        boulder.explode();
                    }
                }
            } else if (this.isFalling()) {
                height = this.getHeight();
                this.setHeight(height -= 0.25f);
                if ((double)height <= 0.0) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
        this.m_20011_(this.m_142242_());
        AABB popUpBounds = this.m_20191_().m_82406_((double)0.1f);
        List popUpEntities = this.m_9236_().m_45933_((Entity)this, popUpBounds);
        for (Entity entity : popUpEntities) {
            double belowAmount;
            if (!entity.m_6087_() || entity instanceof EntityBoulderBase || entity instanceof EntityPillar || entity instanceof EntityPillarPiece || !((belowAmount = entity.m_20186_() - (this.m_20186_() + (double)this.getHeight())) < 0.0)) continue;
            entity.m_6478_(MoverType.PISTON, new Vec3(0.0, -belowAmount, 0.0));
        }
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && (this.getCaster() == null || this.getCaster().m_213877_() || (double)this.getCaster().m_21223_() <= 0.0)) {
            this.explode();
        }
    }

    protected AABB m_142242_() {
        if (this.f_19797_ <= 1) {
            return super.m_142242_();
        }
        float f = (float)SIZE_MAP.get((Object)this.getTier()).intValue() / 2.0f - 0.05f;
        return new AABB(this.m_20185_() - (double)f, this.m_20186_(), this.m_20189_() - (double)f, this.m_20185_() + (double)f, this.m_20186_() + (double)this.getHeight() - (double)0.05f, this.m_20189_() + (double)f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HEIGHT, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(RISING, (Object)true);
        this.m_20088_().m_135372_(FALLING, (Object)false);
    }

    public float getHeight() {
        return ((Float)this.m_20088_().m_135370_(HEIGHT)).floatValue();
    }

    public void setHeight(float height) {
        this.m_20088_().m_135381_(HEIGHT, (Object)Float.valueOf(height));
    }

    public void stopRising() {
        this.m_20088_().m_135381_(RISING, (Object)false);
        this.m_20011_(this.m_142242_());
        this.currentPiece = new EntityPillarPiece((EntityType)EntityHandler.PILLAR_PIECE.get(), this.m_9236_(), this, new Vec3(this.m_20185_(), this.m_20186_() + (double)this.getHeight() - 1.0, this.m_20189_()));
        this.m_9236_().m_7967_((Entity)this.currentPiece);
    }

    public boolean isRising() {
        return (Boolean)this.m_20088_().m_135370_(RISING);
    }

    public void startFalling() {
        this.m_20088_().m_135381_(RISING, (Object)false);
        this.m_20088_().m_135381_(FALLING, (Object)true);
    }

    public void startRising() {
        this.m_20088_().m_135381_(RISING, (Object)true);
        this.m_20088_().m_135381_(FALLING, (Object)false);
    }

    public boolean isFalling() {
        return (Boolean)this.m_20088_().m_135370_(FALLING);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("height", this.getHeight());
        compound.m_128379_("rising", this.isRising());
        compound.m_128379_("falling", this.isFalling());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHeight(compound.m_128457_("height"));
        this.m_20088_().m_135381_(RISING, (Object)compound.m_128471_("rising"));
        this.m_20088_().m_135381_(FALLING, (Object)compound.m_128471_("falling"));
    }

    @Override
    public boolean doRemoveTimer() {
        return !(this.getCaster() instanceof EntitySculptor);
    }

    @Override
    public boolean isRumbling() {
        return !this.m_213877_() && (this.isFalling() || this.isRising());
    }

    @Override
    public boolean isFinishedRumbling() {
        return this.m_213877_();
    }

    @Override
    public float getRumblerX() {
        return (float)this.m_20185_();
    }

    @Override
    public float getRumblerY() {
        return (float)this.m_20186_();
    }

    @Override
    public float getRumblerZ() {
        return (float)this.m_20189_();
    }

    static {
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.NONE, 1);
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.SMALL, 2);
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.MEDIUM, 3);
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.LARGE, 4);
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.HUGE, 5);
    }

    public static class EntityPillarSculptor
    extends EntityPillar {
        public EntityPillarSculptor(EntityType<? extends EntityPillarSculptor> type, Level worldIn) {
            super(type, worldIn);
        }

        public EntityPillarSculptor(EntityType<? extends EntityPillarSculptor> type, Level world, LivingEntity caster, BlockState blockState, BlockPos pos) {
            super((EntityType<? extends EntityPillar>)type, world, caster, blockState, pos);
            this.setDeathTime(300);
        }

        public double getDesiredHeight() {
            return EntitySculptor.TEST_HEIGHT;
        }

        @Override
        public void m_8119_() {
            if (this.getCaster() instanceof EntitySculptor) {
                EntitySculptor sculptor = (EntitySculptor)this.getCaster();
                if (sculptor.getPillar() == null) {
                    sculptor.setPillar(this);
                }
                if (this.m_9236_().m_8055_(this.getCaster().m_20183_().m_6630_((int)(this.getCaster().m_20206_() + 1.0f))).m_280555_()) {
                    this.stopRising();
                }
                if (!(this.m_9236_().m_5776_() || sculptor.isFighting() || sculptor.isTesting())) {
                    this.startFalling();
                }
            }
            super.m_8119_();
            if ((double)this.getHeight() >= this.getDesiredHeight() && this.isRising()) {
                this.stopRising();
            }
        }

        @Override
        public void stopRising() {
            super.stopRising();
        }
    }
}

